 ; Wait! - a seashell isn't a logarithmic spiral... or maybe it is, but
 ; nature doesn't use logarithms.  The inner ridge of one wrap lies along the
 ; outer ridge of the next one in, forcing a constant rate of expansion...
 ; or going along with that set by the growth of the creature within the
 ; shell.  Rewrite to make one line hit the previous one, calculate the
 ; growth rate from this.  No exponent base is required, and both horizontal
 ; and vertical alignment can be handled in the same way.  Also a switch
 ; could be added to unwrap the shell slightly to allow a better impression
 ; of the structure.
 ; The scaler subroutine doesn't seem to be neccessary any more... or is it?
 ; Ŀ
 ;   Curl - curly seashell drawer.                                         
 ;   Copyright 1995 by Rocket Software                                     
 ;                                                                         
 ; 

 ; Ŀ
 ;   CU&D - error handler.                                                 
 ; 
 (DEFUN CU&D (shk / listno spawn)
  (setq *error* esav)
  (setq listno 1)                     ; initialise "n" for listn vars
  (setq spawn "list1")
  (while (eval (read spawn))
         (set (read spawn) ())
         (setq listno (1+ listno))
         (setq spawn (strcat "list" (itoa listno))))
  (if (/= shk "Function cancelled")
      (write-line shk))
 (princ))
 ; Ŀ
 ;   Subroutine CU&D end.                                                  
 ; 


 ; Ŀ
 ;   Subroutine Do - get seashell half outline.  Returns a list of lists   
 ;   of out and down values for the chosen outline points.                 
 ; 
 (DEFUN DO (/ pa pta down out llist)
  (setq pa (getvar "viewctr"))
  (while (setq pta (getpoint pa "Next point: "))
         (setq down (- (cadr pta) (cadr pa)))
         (setq out (- (car pta) (car pa)))
         (setq llist (append llist (list (list out down)))))
 llist)
 ; Ŀ
 ;   Subroutine Do end.                                                    
 ; 


 ; Ŀ
 ;   Subroutine Lstscl - scale a list of lists of numbers.                 
 ; 
 (DEFUN LSTSCL (lisst scal / sub out down gnulst)
  (while (setq sub (car lisst))
         (setq lisst (cdr lisst))
         (setq out (* (car sub) scal))
         (setq down (* (cadr sub) scal))
         (setq sub (list (list out down)))
         (setq gnulst (append gnulst sub)))
 gnulst)
 ; Ŀ
 ;   Subroutine Lstscl end.                                                
 ; 


 ; Ŀ
 ;   Curl - the rind.                                                      
 ; 
 (DEFUN C:CURL (/ pa pts anginc revp basep llist 1stout angg
                                            num down rad listno spawn sub pta)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq esav *error*)                   ; save the previous error handler
  (setq *error* cu&d)                   ; and install the new one
  (setq pa (getvar "viewctr"))
 ; Ŀ
 ;   First get the number of points per rotation.                          
 ; 
  (if (/= (type points) 'INT) (setq points 100))
 ; Ŀ
 ;   Initget: 1 = not null, 2 = nonzero, 4 = positive.                     
 ; 
  (initget 6)                             ; only accept positive nonzero input
  (setq pts (getint (strcat "\nPoints/revolution <" (itoa points) ">: ")))
  (if pts (setq points pts))
  (setq anginc (/ (* 2 pi) points))
 ; Ŀ
 ;   Get the number of rotations.                                          
 ; 
  (initget 6)                             ; only accept positive nonzero input
  (if (/= (type revs) 'INT) (setq revs 5))
  (setq revp (getint (strcat "\nRevolutions <" (itoa revs) ">: ")))
  (if revp (setq revs revp))
 ; Ŀ
 ;   And the exponent base - the radius of a logarithmic spiral is the     
 ;   base raised to the value of the angle of that point, so the rate of   
 ;   increase of the spiral can be controlled by specifying a base value.  
 ; 
  (initget 2)                             ; only accept nonzero input
  (if (/= (type base) 'REAL) (setq base 1.25))
  (setq basep (getreal (strcat "\nExponent base <" (rtos base 2 2) ">: ")))
  (if basep (setq base basep))
 ; Ŀ
 ;   Call Do to make the outline list.                                     
 ; 
  (setq llist (do))
  (setq 1stout (caar llist))      ; first horizontal value for scale purposes
(print 1stout)
 ; Ŀ
 ;   Scale Llist so that the horizontal component of the first segment is  
 ;   equal to the distance between the two laps of the spiral at that      
 ;   angle.  Thus successive curves of the shell will fit against each     
 ;   other.                                                                
 ;   So: the radius at the start point will be 1 (n^0 = 1 for all n) and   
 ;   r at 2pi radians = (base^2pi), so the difference = (- (base^2pi) 1).  
 ;                                                                         
 ;   Hang on...                                                            
 ;                                                                         
 ;                                                                         
 ;                                                                         
 ;                                                                         
 ; 
  (setq diff (- (expt base (* 2 pi)) 1))
(print diff)
(print llist)
  (setq llist (lstscl llist (/ diff 1stout)))
(print llist)
 ; Ŀ
 ;   Initialize angle, segment counter, and vertical drop.                 
 ; 
  (setq angg 0)
  (setq num 0)
  (setq down 0)
 ; Ŀ
 ;   Make the lists of points to be used by the 3dmesh command.            
 ;   There will be one list for each point sublist in Llist (the outline   
 ;   points list).  Each point in each list must be scaled by the same     
 ;   amount as the shell radius at that point.                             
 ; 
  (repeat (* points revs)
          (setq num (1+ num))
          (setq rad (expt base angg))
 ; Ŀ
 ;   Now have a radius and an angle.  Need to add X,Y and Z coordinates    
 ;   (i.e. a point) for each point in Llist to each corresponding point    
 ;   list for eventual use by the 3dmesh command.                          
 ; 
          (setq listno 1)                     ; initialise "n" for listn vars
          (repeat (length llist)
                  (setq spawn (strcat "list" (itoa listno)))
 ; Ŀ
 ;   Now have a list name in spawn and can update the list.                
 ; 
                  (setq sub (nth (1- listno) llist))   ; sublist from pointlist
                  (setq pta (polar pa angg (* rad (car sub))))
                  (setq pax (list (car pta) (cadr pta) (* rad (cadr sub))))
                  (set (read spawn) (append (eval (read spawn)) (list pax)))
                  (grtext -2 (strcat (itoa num) "/" (itoa listno)))
                  (setq listno (1+ listno)))
 ; Ŀ
 ;   All point lists are updated at this point. Now increment the angle    
 ;   and loop back for the next point.                                     
 ; 
          (setq angg (+ angg anginc)))
 ; Ŀ
 ;   Initialise counter, start 3dmesh command.                             
 ; 
  (setq num 0)
  (command "3dmesh" (length llist) (* points revs))
 ; Ŀ
 ;   Pass the points to the command.                                       
 ; 
  (setq listno 1)                     ; initialise "n" for listn vars
  (repeat (length llist)
          (setq spawn (strcat "list" (itoa listno)))
          (setq num 0)
          (while (setq pta (nth num (eval (read spawn))))
                 (command pta)
                 (setq num (1+ num)))
          (set (read spawn) ())
          (setq listno (1+ listno)))
  (setq *error* esav)        ; restore the original error handler
 (princ))